package gov.va.med.mhv.usermgmt.data.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;

@Entity
@Table(name = "USER_PROFILE_DEACT_AUDIT")
public class UserProfileDeactivationAudit extends AbstractBaseEntity {

	private static final long serialVersionUID = -2767521837290509593L;

	@Id
	@Column(name = "USER_PROFILE_DEACT_AUDIT_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "CHANGED_BY")
	private String changedBy;

	@Column(name = "ACTION")
	private Integer action;

	@Column(name = "CHANGE_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date changeDate;
	
	@Column(name = "NOTES")
	private String notes;

	@Column(name = "USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_ID")
	private UserProfile userProfile;

	@Column(name = "USER_PROFILE_DEACT_REASON_ID", insertable = false, updatable = false)
	private Long deactivationReasonId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_DEACT_REASON_ID")
	private UserProfileDeactivationReason deactivationReason;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getChangedBy() {
		return changedBy;
	}

	public void setChangedBy(String changedBy) {
		this.changedBy = changedBy;
	}

	public Integer getAction() {
		return action;
	}

	public void setAction(Integer action) {
		this.action = action;
	}

	public Date getChangeDate() {
		return changeDate;
	}

	public void setChangeDate(Date changeDate) {
		this.changeDate = changeDate;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public Long getDeactivationReasonId() {
		return deactivationReasonId;
	}

	public void setDeactivationReasonId(Long deactivationReasonId) {
		this.deactivationReasonId = deactivationReasonId;
	}

	public UserProfileDeactivationReason getDeactivationReason() {
		return deactivationReason;
	}

	public void setDeactivationReason(UserProfileDeactivationReason deactivationReason) {
		this.deactivationReason = deactivationReason;
	}

}
